using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;

class Program
{
    static void Main()
    {
        var first = Console.ReadLine().Split();
        int n = int.Parse(first[0]);
        long W = long.Parse(first[1]);
        double eps = double.Parse(first[2], CultureInfo.InvariantCulture);

        long[] w = new long[n];
        long[] v = new long[n];
        long vmax = 0;

        for (int i = 0; i < n; i++)
        {
            var p = Console.ReadLine().Split();
            w[i] = long.Parse(p[0]);
            v[i] = long.Parse(p[1]);
            if (v[i] > vmax) vmax = v[i];
        }

        if (vmax == 0)
        {
            Console.WriteLine(0);
            Console.WriteLine();
            return;
        }

        double Kd = eps * vmax / n;
        if (Kd <= 0) Kd = 1.0;

        int[] vs = new int[n];
        int sumV = 0;
        for (int i = 0; i < n; i++)
        {
            vs[i] = (int)Math.Floor(v[i] / Kd);
            sumV += vs[i];
        }

        long INF = long.MaxValue / 4;
        long[] dp = new long[sumV + 1];
        int[,] parent = new int[n + 1, sumV + 1];

        for (int i = 1; i <= sumV; i++) dp[i] = INF;
        dp[0] = 0;

        for (int i = 0; i < n; i++)
        {
            for (int x = sumV; x >= vs[i]; x--)
            {
                if (dp[x - vs[i]] + w[i] < dp[x])
                {
                    dp[x] = dp[x - vs[i]] + w[i];
                    parent[i + 1, x] = 1;
                }
            }
        }

        int best = 0;
        for (int x = 0; x <= sumV; x++)
            if (dp[x] <= W && x > best)
                best = x;

        List<int> res = new List<int>();
        int cur = best;
        for (int i = n; i >= 1; i--)
        {
            if (cur >= 0 && parent[i, cur] == 1)
            {
                res.Add(i);
                cur -= vs[i - 1];
            }
        }

        res.Reverse();
        Console.WriteLine(res.Count);
        if (res.Count > 0)
            Console.WriteLine(string.Join(" ", res));
        else
            Console.WriteLine();
    }
}